/*
 * AltaLocal.java
 *
 * Created on 9 de junio de 2008, 21:19
 */

package actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author Administrador
 * @version
 */

public class AltaLocal extends Action {
    
    DataSource ds = null;
    Connection con = null;
    String sql = "";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Local local = (Local) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            PreparedStatement sentencia = null;
            
            if (local.getIdPropietari() == 0 ) {
                local.setError("<font color='red'>S'ha de seleccionar un propietari</font>");
                return mapping.findForward("ok");
            }
            
            if (local.getZona().equals("0") ) {
                local.setError("<font color='red'>S'ha de seleccionar una zona</font>");
                return mapping.findForward("ok");
            }
            
            if (local.getAdresa().isEmpty() /*|| local.getPreu() || local.getSuperficie()*/) {
                local.setError("<font color='red'>Hi han camps buids obligatoris.<br>" +
                        "Els camps obligatoris son: Adrea, Preu i Superficie</font>");
                return mapping.findForward("ok");
            }
            
            //Comprova si el local ja esta a la bd
            sentencia = con.prepareStatement("SELECT * FROM locals WHERE id_zona = ? AND UPPER(adresa) LIKE ? AND tipus = ?");
            sentencia.setInt(1, local.getIdZona());
            sentencia.setString(2, local.getAdresa().toUpperCase().trim());
            sentencia.setString(3, local.getTipus());
            rs = sentencia.executeQuery();
            if (rs.next())
            {
                local.setError("<font color='red'>El local ja existeix a la base de dades</font>");
                return mapping.findForward("ok");
            }
            
            sql = "INSERT INTO locals";
            sql += " (id_propietari, codi_local, actiu, id_zona, adresa, restriccions, caracteristiques, superficie, preu, tipus";
            if (local.getTipus().equals("polivalent"))
            {
                sql += ", caracteristiques_polivalent";
            }
            if (local.getTipus().equals("botiga_magatzem"))
            {
                sql += ", volum";
            }
            
            sql += " ) VALUES (?,?,?,?,?,?,?,?,?,?";
            
            if (local.getTipus().equals("polivalent") || local.getTipus().equals("botiga_magatzem"))
                sql+= ",?";
            
            sql +=")";
            
            sentencia = con.prepareStatement(sql);
            sentencia.setInt(1, local.getIdPropietari());
            sentencia.setString(2, null);
            sentencia.setBoolean(3, false);
            sentencia.setInt(4, local.getIdZona());
            sentencia.setString(5, local.getAdresa());
            sentencia.setString(6, local.getRestriccions());
            sentencia.setString(7, local.getCaracteristiques());
            sentencia.setFloat(8, local.getSuperficie());
            sentencia.setFloat(9, local.getPreu());
            sentencia.setString(10, local.getTipus());
            if (local.getTipus().equals("polivalent"))
            {
                sentencia.setString(11, local.getCaracteristiquesPolivalents());
            }
            if (local.getTipus().equals("botiga_magatzem"))
            {
                sentencia.setFloat(11, local.getVolum());
            }
            sentencia.executeUpdate();
            
            rs = st.executeQuery("SELECT LAST_INSERT_ID()");
            rs.next();
            local.setIdLocal(rs.getInt(1));
            
            st.executeUpdate("UPDATE locals SET codi_local = '"+local.generaCodiLocal()+"' WHERE id = "+local.getIdLocal());
            
            local.setError("<font color='blue'>Local introduit a la base de dades</font>");
        }catch(Exception excepcio){
            local.setError("<font color='red'>Excepcio ocorreguda en actions.altaLocal:<br>" +
                    ""+excepcio.getMessage()+"</font>");
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                local.setError("<font color='red'>Excepcio ocorreguda en actions.altaLocal:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
